// VERSION :Scilab:6.0.1
// OS : WINDOWS 10
// CAPTION:BASIC OPERATION ON DISCRETE TIME SIGNALS
clc ;
clear all;
close ;
//Input DT Signal
n=-2:1:2;
x=[1,1,0,0.5,0.5];
subplot (2,3,1);
plot2d3(n,x,style=[color("blue")]);
xgrid(4,1,7);
xlabel("n");
ylabel("Amplitude");
title("Input DT Signal x(n)");

//Amplitude Scaling
a=2; // Scaling factor
subplot (2,3,2);
plot2d3(n,a*x,style=[color("blue")]);
xgrid(4,1,7);
xlabel("n");
ylabel("Amplitude");
title("z(n)=2*x(n)");

//Amplitude Scaling
a=0.5; // Scaling factor
subplot (2,3,3);
plot2d3(n,a*x,style=[color("blue")]);
xgrid(4,1,7);
xlabel("n");
ylabel("Amplitude");
title("z(n)=0.5*x(n)");

// Time reversal
subplot (2,3,4);
plot2d3(-n,x,style=[color("blue")]);
xgrid(4,1,7);
xlabel("n");
ylabel("Amplitude");
title("z(n)=x(-n)");

//Time Shifting
subplot (2,3,5);
plot2d3(n+2,x,style=[color("blue")]);
xgrid(4,1,7);
xlabel("n");
ylabel("Amplitude");
title("z(n)=x(n+2)");

//Time Shifting
subplot (2,3,6);
plot2d3(n-2,x,style=[color("blue")]);
xgrid(4,1,7);
xlabel("n");
ylabel("Amplitude");
title("z(n)=x(n-2)");

